package net.udooz.azure.jaz;

import java.io.IOException;
import java.util.concurrent.ExecutionException;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import com.ning.http.client.AsyncHandler.STATE;


public class App 
{
    public static void main( String[] args )
    		throws IOException, ClassNotFoundException
    {
    	AzureStorage blobStorage = new AzureStorage("account-name", "blob|table|queue", "sharedkey");
		Request request = blobStorage.get("ablobcontainer/?restype=container&comp=list");
		AsyncHttpClient client = new AsyncHttpClient();
		ListenableFuture<Response> response = client.executeRequest(request, new AsyncHandler<Response>() {
			private final Response.ResponseBuilder builder = new Response.ResponseBuilder();

		    public STATE onBodyPartReceived(final HttpResponseBodyPart content) throws Exception {
		        builder.accumulate(content);
		        return STATE.CONTINUE;
		    }

		    public STATE onStatusReceived(final HttpResponseStatus status) throws Exception {
		        builder.accumulate(status);
		        return STATE.CONTINUE;
		    }

		    public STATE onHeadersReceived(final HttpResponseHeaders headers) throws Exception {
		        builder.accumulate(headers);
		        return STATE.CONTINUE;
		    }

		    public Response onCompleted() throws Exception {
		        return builder.build();
		    }

			public void onThrowable(Throwable arg0) {
				// TODO Auto-generated method stub
				
			}
		});
		
		while(! response.isDone()) {
			if(response.isCancelled()) break;			
		}
		
		Response actualResponse;
		try {
			actualResponse = response.get();
			
			System.out.println(actualResponse.getStatusCode());
			System.out.println(actualResponse.getResponseBody());
			
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ExecutionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		System.out.println("Program exit");
    }
}
